<?php

return [
    'customers' => [
        'forgot-password' => [
            'already-sent'         => 'E-Mail zum Zurücksetzen des Passworts wurde bereits gesendet.',
            'back'                 => 'Zurück zur Anmeldung?',
            'bagisto'              => 'Bagisto',
            'email'                => 'E-Mail',
            'email-not-exist'      => 'Wir konnten keinen Benutzer mit dieser E-Mail-Adresse finden.',
            'footer'               => '© Copyright 2010 - :current_year, Webkul Software (in Indien registriert). Alle Rechte vorbehalten.',
            'forgot-password-text' => 'Wenn Sie Ihr Passwort vergessen haben, stellen Sie es wieder her, indem Sie Ihre E-Mail-Adresse eingeben.',
            'page-title'           => 'Passwort vergessen?',
            'reset-link-sent'      => 'Wir haben Ihnen den Link zum Zurücksetzen Ihres Passworts per E-Mail gesendet.',
            'sign-in-button'       => 'Anmelden',
            'submit'               => 'Passwort zurücksetzen',
            'title'                => 'Passwort wiederherstellen',
        ],

        'reset-password' => [
            'back-link-title'  => 'Zurück zur Anmeldung',
            'bagisto'          => 'Bagisto',
            'confirm-password' => 'Passwort bestätigen',
            'email'            => 'Registrierte E-Mail',
            'footer'           => '© Copyright 2010 - :current_year, Webkul Software (in Indien registriert). Alle Rechte vorbehalten.',
            'password'         => 'Passwort',
            'submit-btn-title' => 'Passwort zurücksetzen',
            'title'            => 'Passwort zurücksetzen',
        ],

        'login-form' => [
            'bagisto'             => 'Bagisto',
            'button-title'        => 'Anmelden',
            'create-your-account' => 'Erstellen Sie Ihr Konto',
            'email'               => 'E-Mail',
            'footer'              => '© Copyright 2010 - :current_year, Webkul Software (in Indien registriert). Alle Rechte vorbehalten.',
            'forgot-pass'         => 'Passwort vergessen?',
            'form-login-text'     => 'Wenn Sie bereits ein Konto haben, melden Sie sich mit Ihrer E-Mail-Adresse an.',
            'invalid-credentials' => 'Bitte überprüfen Sie Ihre Anmeldedaten und versuchen Sie es erneut.',
            'new-customer'        => 'Neuer Kunde?',
            'not-activated'       => 'Ihre Aktivierung erfordert die Zustimmung des Administrators',
            'page-title'          => 'Kundenanmeldung',
            'password'            => 'Passwort',
            'show-password'       => 'Passwort anzeigen',
            'title'               => 'Anmelden',
            'verify-first'        => 'Bitte verifizieren Sie zuerst Ihr E-Mail-Konto.',
        ],

        'signup-form' => [
            'account-exists'              => 'Bereits ein Konto?',
            'bagisto'                     => 'Bagisto',
            'button-title'                => 'Registrieren',
            'click-here'                  => 'Hier klicken',
            'confirm-pass'                => 'Passwort bestätigen',
            'email'                       => 'E-Mail',
            'first-name'                  => 'Vorname',
            'footer'                      => '© Copyright 2010 - :current_year, Webkul Software (in Indien registriert). Alle Rechte vorbehalten.',
            'form-signup-text'            => 'Wenn Sie neu in unserem Geschäft sind, freuen wir uns, Sie als Mitglied begrüßen zu dürfen.',
            'last-name'                   => 'Nachname',
            'page-title'                  => 'Benutzer werden',
            'password'                    => 'Passwort',
            'sign-in-button'              => 'Anmelden',
            'subscribe-to-newsletter'     => 'Newsletter abonnieren',
            'success'                     => 'Konto erfolgreich erstellt.',
            'success-verify'              => 'Konto erfolgreich erstellt, eine E-Mail zur Verifizierung wurde gesendet.',
            'terms-conditions'            => 'Allgemeine Geschäftsbedingungen',
            'verification-not-sent'       => 'Fehler! Problem beim Senden der Verifizierungs-E-Mail, bitte versuchen Sie es später erneut.',
            'verification-sent'           => 'Verifizierungs-E-Mail gesendet',
            'verified'                    => 'Ihr Konto wurde verifiziert, versuchen Sie sich jetzt anzumelden.',
            'verify-failed'               => 'Wir können Ihr E-Mail-Konto nicht verifizieren.',
        ],

        'account' => [
            'home' => 'Startseite',

            'profile' => [
                'index' => [
                    'delete'         => 'Löschen',
                    'delete-failed'  => 'Fehler beim Löschen des Kunden aufgetreten.',
                    'delete-profile' => 'Profil löschen',
                    'delete-success' => 'Kunde erfolgreich gelöscht',
                    'dob'            => 'Geburtsdatum',
                    'edit'           => 'Bearbeiten',
                    'edit-success'   => 'Profil erfolgreich aktualisiert',
                    'email'          => 'E-Mail',
                    'enter-password' => 'Geben Sie Ihr Passwort ein',
                    'first-name'     => 'Vorname',
                    'gender'         => 'Geschlecht',
                    'last-name'      => 'Nachname',
                    'order-pending'  => 'Kundenkonto kann nicht gelöscht werden, da noch Bestellung(en) ausstehend oder in Bearbeitung sind.',
                    'title'          => 'Profil',
                    'unmatched'      => 'Das alte Passwort stimmt nicht überein.',
                    'wrong-password' => 'Falsches Passwort!',
                ],

                'edit' => [
                    'confirm-password'        => 'Passwort bestätigen',
                    'current-password'        => 'Aktuelles Passwort',
                    'dob'                     => 'Geburtsdatum',
                    'edit'                    => 'Bearbeiten',
                    'edit-profile'            => 'Profil bearbeiten',
                    'email'                   => 'E-Mail',
                    'female'                  => 'Weiblich',
                    'first-name'              => 'Vorname',
                    'gender'                  => 'Geschlecht',
                    'last-name'               => 'Nachname',
                    'male'                    => 'Männlich',
                    'new-password'            => 'Neues Passwort',
                    'other'                   => 'Andere',
                    'phone'                   => 'Telefon',
                    'save'                    => 'Speichern',
                    'subscribe-to-newsletter' => 'Newsletter abonnieren',
                ],
            ],

            'addresses' => [
                'index' => [
                    'add-address'      => 'Adresse hinzufügen',
                    'create-success'   => 'Adresse wurde erfolgreich hinzugefügt.',
                    'default-address'  => 'Standardadresse',
                    'default-delete'   => 'Die Standardadresse kann nicht geändert werden.',
                    'delete'           => 'Löschen',
                    'delete-success'   => 'Adresse erfolgreich gelöscht',
                    'edit'             => 'Bearbeiten',
                    'edit-success'     => 'Adresse erfolgreich aktualisiert.',
                    'empty-address'    => 'Sie haben noch keine Adresse zu Ihrem Konto hinzugefügt.',
                    'security-warning' => 'Verdächtige Aktivität festgestellt!!!',
                    'set-as-default'   => 'Als Standard festlegen',
                    'title'            => 'Adresse',
                    'update-success'   => 'Adresse wurde erfolgreich aktualisiert.',
                ],

                'create' => [
                    'add-address'    => 'Adresse hinzufügen',
                    'city'           => 'Stadt',
                    'company-name'   => 'Firmenname',
                    'country'        => 'Land',
                    'email'          => 'E-Mail',
                    'first-name'     => 'Vorname',
                    'last-name'      => 'Nachname',
                    'phone'          => 'Telefon',
                    'post-code'      => 'Postleitzahl',
                    'save'           => 'Speichern',
                    'select-country' => 'Land auswählen',
                    'set-as-default' => 'Als Standard festlegen',
                    'state'          => 'Bundesland',
                    'street-address' => 'Straße und Hausnummer',
                    'title'          => 'Adresse',
                    'vat-id'         => 'USt-IdNr.',
                ],

                'edit' => [
                    'city'           => 'Stadt',
                    'company-name'   => 'Firmenname',
                    'country'        => 'Land',
                    'edit'           => 'Bearbeiten',
                    'email'          => 'E-Mail',
                    'first-name'     => 'Vorname',
                    'last-name'      => 'Nachname',
                    'phone'          => 'Telefon',
                    'post-code'      => 'Postleitzahl',
                    'select-country' => 'Land auswählen',
                    'state'          => 'Bundesland',
                    'street-address' => 'Straße und Hausnummer',
                    'title'          => 'Adresse',
                    'update-btn'     => 'Aktualisieren',
                    'vat-id'         => 'USt-IdNr.',
                ],
            ],

            'orders' => [
                'action'      => 'Aktion',
                'action-view' => 'Ansehen',
                'empty-order' => 'Sie haben noch kein Produkt bestellt',
                'order'       => 'Bestellung',
                'order-date'  => 'Bestelldatum',
                'order-id'    => 'Bestell-ID',
                'subtotal'    => 'Zwischensumme',
                'title'       => 'Bestellungen',
                'total'       => 'Gesamt',

                'status' => [
                    'title' => 'Status',

                    'options' => [
                        'canceled'        => 'Abgebrochen',
                        'closed'          => 'Geschlossen',
                        'completed'       => 'Abgeschlossen',
                        'fraud'           => 'Betrug',
                        'pending'         => 'Ausstehend',
                        'pending-payment' => 'Zahlung ausstehend',
                        'processing'      => 'Verarbeitung',
                    ],
                ],

                'view' => [
                    'billing-address'      => 'Rechnungsadresse',
                    'cancel-btn-title'     => 'Abbrechen',
                    'cancel-confirm-msg'   => 'Sind Sie sicher, dass Sie diese Bestellung stornieren möchten?',
                    'cancel-error'         => 'Ihre Bestellung kann nicht storniert werden.',
                    'cancel-success'       => 'Ihre Bestellung wurde storniert',
                    'contact'              => 'Kontakt',
                    'item-invoiced'        => 'Artikel in Rechnung gestellt',
                    'item-refunded'        => 'Artikel erstattet',
                    'item-shipped'         => 'Artikel versendet',
                    'item-ordered'         => 'Artikel bestellt',
                    'order-id'             => 'Bestellnummer',
                    'page-title'           => 'Bestellung #:order_id',
                    'payment-method'       => 'Zahlungsmethode',
                    'reorder-btn-title'    => 'Erneut bestellen',
                    'shipping-address'     => 'Lieferadresse',
                    'shipping-method'      => 'Versandmethode',
                    'shipping-and-payment' => 'Versand- und Zahlungsdetails',
                    'status'               => 'Status',
                    'title'                => 'Ansehen',
                    'total'                => 'Gesamt',

                    'information' => [
                        'discount'                   => 'Rabatt',
                        'excl-tax'                   => 'Ohne Steuer:',
                        'grand-total'                => 'Gesamtsumme',
                        'info'                       => 'Information',
                        'item-canceled'              => 'Storniert (:qty_canceled)',
                        'item-refunded'              => 'Erstattet (:qty_refunded)',
                        'invoiced-item'              => 'In Rechnung gestellt (:qty_invoiced)',
                        'item-shipped'               => 'Versendet (:qty_shipped)',
                        'item-status'                => 'Artikelstatus',
                        'ordered-item'               => 'Bestellt (:qty_ordered)',
                        'placed-on'                  => 'Bestellt am',
                        'price'                      => 'Preis',
                        'product-name'               => 'Name',
                        'shipping-handling'          => 'Versand & Bearbeitung',
                        'shipping-handling-excl-tax' => 'Versand & Bearbeitung (ohne Steuer)',
                        'shipping-handling-incl-tax' => 'Versand & Bearbeitung (inkl. Steuer)',
                        'sku'                        => 'Artikelnummer',
                        'subtotal'                   => 'Zwischensumme',
                        'subtotal-excl-tax'          => 'Zwischensumme (ohne Steuer)',
                        'subtotal-incl-tax'          => 'Zwischensumme (inkl. Steuer)',
                        'order-summary'              => 'Bestellübersicht',
                        'tax'                        => 'Steuer',
                        'tax-amount'                 => 'Steuerbetrag',
                        'tax-percent'                => 'Steuerprozentsatz',
                        'total-due'                  => 'Gesamtbetrag fällig',
                        'total-paid'                 => 'Gesamtbetrag bezahlt',
                        'total-refunded'             => 'Gesamtbetrag erstattet',
                    ],

                    'invoices' => [
                        'discount'                   => 'Rabatt',
                        'excl-tax'                   => 'Ohne Steuer:',
                        'grand-total'                => 'Gesamtsumme',
                        'individual-invoice'         => 'Rechnung #:invoice_id',
                        'invoices'                   => 'Rechnungen',
                        'price'                      => 'Preis',
                        'print'                      => 'Drucken',
                        'product-name'               => 'Name',
                        'products-ordered'           => 'Bestellte Produkte',
                        'qty'                        => 'Menge',
                        'shipping-handling-excl-tax' => 'Versand & Bearbeitung (ohne Steuer)',
                        'shipping-handling-incl-tax' => 'Versand & Bearbeitung (inkl. Steuer)',
                        'shipping-handling'          => 'Versand & Bearbeitung',
                        'sku'                        => 'Artikelnummer',
                        'subtotal-excl-tax'          => 'Zwischensumme (ohne Steuer)',
                        'subtotal-incl-tax'          => 'Zwischensumme (inkl. Steuer)',
                        'subtotal'                   => 'Zwischensumme',
                        'tax'                        => 'Steuer',
                        'tax-amount'                 => 'Steuerbetrag',
                    ],

                    'shipments' => [
                        'individual-shipment' => 'Lieferung #:shipment_id',
                        'product-name'        => 'Name',
                        'qty'                 => 'Menge',
                        'shipments'           => 'Lieferungen',
                        'sku'                 => 'Artikelnummer',
                        'subtotal'            => 'Zwischensumme',
                        'tracking-number'     => 'Sendungsnummer',
                    ],

                    'refunds' => [
                        'adjustment-fee'             => 'Anpassungsgebühr',
                        'adjustment-refund'          => 'Anpassungserstattung',
                        'discount'                   => 'Rabatt',
                        'grand-total'                => 'Gesamtsumme',
                        'individual-refund'          => 'Erstattung #:refund_id',
                        'no-result-found'            => 'Es wurden keine Aufzeichnungen gefunden.',
                        'order-summary'              => 'Bestellübersicht',
                        'price'                      => 'Preis',
                        'product-name'               => 'Name',
                        'qty'                        => 'Menge',
                        'refunds'                    => 'Erstattungen',
                        'shipping-handling'          => 'Versand & Bearbeitung',
                        'shipping-handling-excl-tax' => 'Versand & Bearbeitung (ohne Steuer)',
                        'shipping-handling-incl-tax' => 'Versand & Bearbeitung (inkl. Steuer)',
                        'sku'                        => 'Artikelnummer',
                        'subtotal'                   => 'Zwischensumme',
                        'subtotal-excl-tax'          => 'Zwischensumme (ohne Steuer)',
                        'subtotal-incl-tax'          => 'Zwischensumme (inkl. Steuer)',
                        'tax'                        => 'Steuer',
                        'tax-amount'                 => 'Steuerbetrag',
                    ],
                ],

                'invoice-pdf' => [
                    'bank-details'               => 'Bankverbindung',
                    'bill-to'                    => 'Rechnung an',
                    'contact-number'             => 'Kontaktnummer',
                    'contact'                    => 'Kontakt',
                    'date'                       => 'Rechnungsdatum',
                    'discount'                   => 'Rabatt',
                    'excl-tax'                   => 'Exkl. MwSt.:',
                    'grand-total'                => 'Gesamtsumme',
                    'invoice-id'                 => 'Rechnungsnummer',
                    'invoice'                    => 'Rechnung',
                    'order-date'                 => 'Bestelldatum',
                    'order-id'                   => 'Bestellnummer',
                    'payment-method'             => 'Zahlungsmethode',
                    'payment-terms'              => 'Zahlungsbedingungen',
                    'price'                      => 'Preis',
                    'product-name'               => 'Produktname',
                    'qty'                        => 'Menge',
                    'ship-to'                    => 'Versand an',
                    'shipping-handling-excl-tax' => 'Versand und Bearbeitung (exkl. MwSt.)',
                    'shipping-handling-incl-tax' => 'Versand und Bearbeitung (inkl. MwSt.)',
                    'shipping-handling'          => 'Versand und Bearbeitung',
                    'shipping-method'            => 'Versandart',
                    'sku'                        => 'Artikelnummer (SKU)',
                    'subtotal-excl-tax'          => 'Zwischensumme (exkl. MwSt.)',
                    'subtotal-incl-tax'          => 'Zwischensumme (inkl. MwSt.)',
                    'subtotal'                   => 'Zwischensumme',
                    'tax-amount'                 => 'MwSt.-Betrag',
                    'tax'                        => 'MwSt.',
                    'vat-number'                 => 'USt-IdNr.',
                ],
            ],

            'reviews' => [
                'empty-review' => 'Sie haben bisher kein Produkt bewertet',
                'title'        => 'Bewertungen',
            ],

            'downloadable-products' => [
                'available'           => 'Verfügbar',
                'completed'           => 'Vollendet',
                'date'                => 'Datum',
                'download-error'      => 'Der Download-Link ist abgelaufen.',
                'expired'             => 'Abgelaufen',
                'empty-product'       => 'Sie haben kein Produkt zum Herunterladen',
                'name'                => 'Downloadbare Produkte',
                'orderId'             => 'Bestellnummer',
                'pending'             => 'Ausstehend',
                'payment-error'       => 'Für diesen Download wurde keine Zahlung geleistet.',
                'records-found'       => 'Datensatz (s) gefunden',
                'remaining-downloads' => 'Verbleibende Downloads',
                'status'              => 'Status',
                'title'               => 'Titel',
            ],

            'wishlist' => [
                'color'              => 'Farbe',
                'delete-all'         => 'Alle löschen',
                'empty'              => 'Es wurden keine Produkte zur Wunschliste hinzugefügt.',
                'move-to-cart'       => 'In den Warenkorb legen',
                'moved'              => 'Artikel erfolgreich in den Warenkorb verschoben',
                'moved-success'      => 'Artikel erfolgreich in den Warenkorb verschoben',
                'page-title'         => 'Wunschliste',
                'product-removed'    => 'Produkt ist nicht mehr verfügbar, da es vom Administrator entfernt wurde',
                'profile'            => 'Profil',
                'remove'             => 'Entfernen',
                'remove-all-success' => 'Alle Artikel aus Ihrer Wunschliste wurden entfernt',
                'remove-fail'        => 'Artikel kann nicht aus der Wunschliste entfernt werden',
                'removed'            => 'Artikel erfolgreich aus der Wunschliste entfernt',
                'see-details'        => 'Details anzeigen',
                'success'            => 'Artikel erfolgreich zur Wunschliste hinzugefügt',
                'title'              => 'Wunschliste',
            ],

            'gdpr' => [
                'create-success'              => 'Anfrage erfolgreich erstellt',
                'revoked-successfully'        => 'Anfrage erfolgreich widerrufen',
                'success-verify'              => 'Erfolg! Bestätigungs-E-Mail wurde gesendet.',
                'success-verify-email-unsent' => 'Erfolg! Bestätigungs-E-Mail wurde nicht gesendet.',
                'unable-to-sent'              => 'E-Mail konnte nicht gesendet werden.',

                'index'   => [
                    'create-btn' => 'Anfrage erstellen',
                    'html'       => 'HTML',
                    'pdf'        => 'PDF',
                    'title'      => 'DSGVO-Datenanfragen',

                    'modal' => [
                        'message' => 'Nachricht',
                        'save'    => 'Speichern',
                        'title'   => 'Neue Anfrage erstellen',

                        'type'    => [
                            'choose' => 'Wählen',
                            'delete' => 'Löschen',
                            'title'  => 'Typ',
                            'update' => 'Aktualisieren',
                        ],
                    ],

                    'datagrid' => [
                        'completed'  => 'Abgeschlossen',
                        'date'       => 'Datum',
                        'declined'   => 'Abgelehnt',
                        'delete'     => 'Löschen',
                        'id'         => 'ID',
                        'message'    => 'Nachricht',
                        'pending'    => 'Ausstehend',
                        'processing' => 'In Bearbeitung',
                        'revoke-btn' => 'Widerrufen',
                        'revoked'    => 'Widerrufen',
                        'status'     => 'Status',
                        'type'       => 'Typ',
                        'update'     => 'Aktualisieren',
                    ],
                ],

                'pdf' => [
                    'title' => 'Standard-Store-Ansicht',

                    'account-info' => [
                        'dob'          => 'Geburtsdatum',
                        'email'        => 'E-Mail',
                        'first-name'   => 'Vorname',
                        'gender'       => 'Geschlecht',
                        'last-name'    => 'Nachname',
                        'phone'        => 'Telefon',
                        'title'        => 'Kontoinformationen',
                    ],

                    'address-info' => [
                        'address'    => 'Adresse',
                        'address1'   => 'Adresse 1',
                        'address2'   => 'Adresse 2',
                        'city'       => 'Stadt',
                        'company'    => 'Firma',
                        'country'    => 'Land',
                        'first-name' => 'Vorname',
                        'last-name'  => 'Nachname',
                        'phone'      => 'Telefon',
                        'postcode'   => 'Postleitzahl',
                        'state'      => 'Bundesland',
                        'title'      => 'Adressinformationen',
                        'vat-id'     => 'USt-IdNr.',
                    ],

                    'order-info' => [
                        'amount'       => 'Betrag',
                        'order-id'     => 'Bestellnummer',
                        'product-name' => 'Produktname',
                        'qty'          => 'Menge',
                        'shipping'     => 'Versand',
                        'sku'          => 'SKU',
                        'status'       => 'Status',
                        'title'        => 'Bestellinformationen',
                        'type'         => 'Typ',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'accordion' => [
            'default-content' => 'Standardinhalt',
            'default-header'  => 'Standardüberschrift',
        ],

        'drawer' => [
            'default-toggle' => 'Standardumschaltung',
        ],

        'media' => [
            'index' => [
                'add-attachments' => 'Anhänge hinzufügen',
                'add-image'       => 'Bild/Video hinzufügen',
            ],
        ],

        'layouts' => [
            'header' => [
                'desktop' => [
                    'top' => [
                        'default-locale' => 'Standardsprache',
                    ],

                    'bottom' => [
                        'all'           => 'Alle',
                        'back-button'   => 'Zurück zum Hauptmenü',
                        'bagisto'       => 'Bagisto',
                        'categories'    => 'Kategorien',
                        'compare'       => 'Vergleichen',
                        'dropdown-text' => 'Warenkorb, Bestellungen & Wunschliste verwalten',
                        'logout'        => 'Abmelden',
                        'orders'        => 'Bestellungen',
                        'profile'       => 'Profil',
                        'search'        => 'Suche',
                        'search-text'   => 'Produkte hier suchen',
                        'sign-in'       => 'Anmelden',
                        'sign-up'       => 'Registrieren',
                        'submit'        => 'Absenden',
                        'welcome'       => 'Willkommen',
                        'welcome-guest' => 'Willkommen Gast',
                        'wishlist'      => 'Wunschliste',
                    ],
                ],

                'mobile' => [
                    'account'       => 'Konto',
                    'back-button'   => 'Zurück zum Hauptmenü',
                    'bagisto'       => 'Bagisto',
                    'compare'       => 'Vergleichen',
                    'currencies'    => 'Währungen',
                    'dropdown-text' => 'Warenkorb, Bestellungen & Wunschliste verwalten',
                    'locales'       => 'Sprachen',
                    'login'         => 'Registrieren oder Anmelden',
                    'logout'        => 'Abmelden',
                    'orders'        => 'Bestellungen',
                    'profile'       => 'Profil',
                    'search'        => 'Suche',
                    'search-text'   => 'Produkte hier suchen',
                    'sign-in'       => 'Anmelden',
                    'sign-up'       => 'Registrieren',
                    'welcome'       => 'Willkommen',
                    'welcome-guest' => 'Willkommen Gast',
                    'wishlist'      => 'Wunschliste',
                ],
            ],

            'footer' => [
                'about-us'               => 'Über uns',
                'contact-us'             => 'Kontaktiere uns',
                'currency'               => 'Währung',
                'customer-service'       => 'Kundenservice',
                'email'                  => 'E-Mail',
                'footer-content'         => 'Fußzeileninhalt',
                'footer-text'            => '© Copyright 2010 - :current_year, Webkul Software (eingetragen in Indien). Alle Rechte vorbehalten.',
                'locale'                 => 'Sprache',
                'newsletter-text'        => 'Bereiten Sie sich auf unseren unterhaltsamen Newsletter vor!',
                'order-return'           => 'Bestellung und Rückgabe',
                'payment-policy'         => 'Zahlungsrichtlinie',
                'privacy-cookies-policy' => 'Datenschutz- und Cookie-Richtlinie',
                'shipping-policy'        => 'Versandrichtlinie',
                'subscribe'              => 'Abonnieren',
                'subscribe-newsletter'   => 'Newsletter abonnieren',
                'subscribe-stay-touch'   => 'Abonnieren Sie, um in Kontakt zu bleiben.',
                'whats-new'              => 'Was gibt es Neues',
            ],

            'cookie' => [
                'index' => [
                    'privacy-policy'           => 'Datenschutzrichtlinie',
                    'reject'                   => 'Ablehnen',
                    'accept'                   => 'Akzeptieren',
                    'learn-more-and-customize' => 'Mehr erfahren und anpassen',
                ],

                'consent' => [
                    'your-cookie-consent-preferences'         => 'Ihre Cookie-Einwilligungspräferenzen',
                    'save-and-continue'                       => 'Speichern und fortfahren',
                    'strictly-necessary'                      => 'Unbedingt erforderlich',
                    'basic-interactions'                      => 'Grundlegende Interaktionen und Funktionen',
                    'experience-enhancement'                  => 'Erlebnisverbesserung',
                    'measurements'                            => 'Messung',
                    'targeting-and-advertising'               => 'Zielgerichtete Werbung',
                ],
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => 'Länge von',
                'results'   => 'Gesamtergebnisse',
                'selected'  => 'Ausgewählte Ergebnisse',

                'mass-actions' => [
                    'must-select-a-mass-action'        => 'Sie müssen eine Massenaktion auswählen.',
                    'must-select-a-mass-action-option' => 'Sie müssen eine Massenaktionsoption auswählen.',
                    'no-records-selected'              => 'Keine Datensätze ausgewählt.',
                    'select-action'                    => 'Aktion auswählen',
                ],

                'search' => [
                    'title' => 'Suche',
                ],

                'filter' => [
                    'apply-filter' => 'Filter anwenden',
                    'title'        => 'Filter',

                    'dropdown' => [
                        'select' => 'Auswählen',

                        'searchable' => [
                            'at-least-two-chars' => 'Geben Sie mindestens 2 Zeichen ein...',
                            'no-results'         => 'Keine Ergebnisse gefunden...',
                        ],
                    ],

                    'custom-filters' => [
                        'clear-all' => 'Alles löschen',
                    ],
                ],
            ],

            'table' => [
                'actions'              => 'Aktionen',
                'next-page'            => 'Nächste Seite',
                'no-records-available' => 'Keine Datensätze verfügbar.',
                'of'                   => 'von insgesamt :total Elementen',
                'page-navigation'      => 'Seitennavigation',
                'page-number'          => 'Seitennummer',
                'previous-page'        => 'Vorherige Seite',
                'showing'              => 'Zeigt :firstItem bis :lastItem',
                'to'                   => 'bis',
            ],
        ],

        'modal' => [
            'default-content' => 'Standardinhalt',
            'default-header'  => 'Standardüberschrift',

            'confirm' => [
                'agree-btn'    => 'Zustimmen',
                'disagree-btn' => 'Nicht zustimmen',
                'message'      => 'Sind Sie sicher, dass Sie diese Aktion ausführen möchten?',
                'title'        => 'Sind Sie sicher?',
            ],
        ],

        'products' => [
            'card' => [
                'add-to-cart'            => 'In den Warenkorb legen',
                'add-to-compare'         => 'Zum Vergleich hinzufügen',
                'add-to-compare-success' => 'Artikel erfolgreich zur Vergleichsliste hinzugefügt.',
                'add-to-wishlist'        => 'Zur Wunschliste hinzufügen',
                'already-in-compare'     => 'Artikel ist bereits zur Vergleichsliste hinzugefügt.',
                'new'                    => 'Neu',
                'review-description'     => 'Seien Sie der Erste, der dieses Produkt bewertet',
                'sale'                   => 'Verkauf',
            ],

            'carousel' => [
                'next'     => 'Nächster',
                'previous' => 'Vorheriger',
                'view-all' => 'Alle anzeigen',
            ],

            'ratings' => [
                'title' => 'Bewertungen',
            ],
        ],

        'range-slider' => [
            'max-range' => 'Höchstbereich',
            'min-range' => 'Mindestbereich',
            'range'     => 'Bereich:',
        ],

        'carousel' => [
            'image-slide' => 'Bildrutsche',
            'next'        => 'Nächster',
            'previous'    => 'Vorheriger',
        ],

        'quantity-changer' => [
            'decrease-quantity' => 'Menge verringern',
            'increase-quantity' => 'Menge erhöhen',
        ],
    ],

    'products' => [
        'prices' => [
            'grouped' => [
                'starting-at' => 'Ab',
            ],

            'configurable' => [
                'as-low-as' => 'Ab',
            ],
        ],

        'sort-by' => [
            'title'   => 'Sortieren nach',
        ],

        'view' => [
            'type' => [
                'simple' => [
                    'customizable-options' => [
                        'none'         => 'Keine',
                        'total-amount' => 'Gesamtbetrag',
                    ],
                ],

                'configurable' => [
                    'select-options'       => 'Bitte wählen Sie eine Option aus',
                    'select-above-options' => 'Bitte wählen Sie die oben stehenden Optionen aus',
                ],

                'bundle' => [
                    'none'         => 'Keine',
                    'total-amount' => 'Gesamtsumme',
                ],

                'downloadable' => [
                    'links'   => 'Links',
                    'sample'  => 'Beispiel',
                    'samples' => 'Beispiele',
                ],

                'grouped' => [
                    'name' => 'Name',
                ],

                'booking' => [
                    'location'    => 'Ort',
                    'view-on-map' => 'Auf Karte anzeigen',

                    'default' => [
                        'slot-duration-in-minutes' => ':minutes Minuten',
                        'slot-duration'            => 'Slot-Dauer',
                    ],

                    'appointment' => [
                        'closed'                   => 'Geschlossen',
                        'see-details'              => 'Details anzeigen',
                        'slot-duration'            => 'Slot-Dauer',
                        'slot-duration-in-minutes' => ':minutes Minuten',
                        'today-availability'       => 'Verfügbarkeit heute',
                    ],

                    'event' => [
                        'book-your-ticket' => 'Buchen Sie Ihr Ticket',
                        'title'            => 'Veranstaltung am :',
                    ],

                    'rental'      => [
                        'choose-rent-option' => 'Mietoption wählen',
                        'daily-basis'        => 'Tagesbasis',
                        'from'               => 'Von',
                        'hourly-basis'       => 'Stundenbasis',
                        'rent-an-item'       => 'Einen Artikel mieten',
                        'select-date'        => 'Datum auswählen',
                        'select-rent-time'   => 'Mietzeit auswählen',
                        'select-slot'        => 'Slot auswählen',
                        'select-time-slot'   => 'Zeitfenster auswählen',
                        'slot'               => 'Slot',
                        'no-slots-available' => 'Keine Slots verfügbar',
                        'to'                 => 'Bis',
                    ],

                    'table'       => [
                        'book-a-table'             => 'Einen Tisch reservieren',
                        'closed'                   => 'Geschlossen',
                        'slot-duration'            => 'Slot-Dauer',
                        'slot-duration-in-minutes' => ':minutes Minuten',
                        'slots-for-all-days'       => 'Für alle Tage anzeigen',
                        'special-notes'            => 'Sonderwünsche/Notizen',
                        'today-availability'       => 'Verfügbarkeit heute',
                    ],

                    'slots' => [
                        'book-an-appointment' => 'Einen Termin buchen',
                        'date'                => 'Datum',
                        'no-slots-available'  => 'Keine Slots verfügbar',
                        'select-slot'         => 'Slot auswählen',
                        'title'               => 'Slot',
                    ],
                ],
            ],

            'gallery' => [
                'product-image'   => 'Produktbild',
                'thumbnail-image' => 'Vorschaubild',
            ],

            'reviews' => [
                'attachments'      => 'Anhänge',
                'cancel'           => 'Abbrechen',
                'comment'          => 'Kommentar',
                'customer-review'  => 'Kundenbewertungen',
                'empty-review'     => 'Keine Bewertungen gefunden, sei der erste, der dieses Produkt bewertet',
                'failed-to-upload' => 'Das Bild konnte nicht hochgeladen werden',
                'load-more'        => 'Mehr laden',
                'name'             => 'Name',
                'rating'           => 'Bewertung',
                'ratings'          => 'Bewertungen',
                'submit-review'    => 'Bewertung absenden',
                'success'          => 'Bewertung erfolgreich übermittelt.',
                'title'            => 'Titel',
                'translate'        => 'Übersetzen',
                'translating'      => 'Übersetzung läuft...',
                'write-a-review'   => 'Eine Bewertung schreiben',
            ],

            'add-to-cart'            => 'In den Warenkorb legen',
            'add-to-compare'         => 'Produkt zur Vergleichsliste hinzugefügt.',
            'add-to-wishlist'        => 'Zur Wunschliste hinzufügen',
            'additional-information' => 'Zusätzliche Informationen',
            'already-in-compare'     => 'Das Produkt ist bereits in der Vergleichsliste enthalten.',
            'buy-now'                => 'Jetzt kaufen',
            'compare'                => 'Vergleichen',
            'description'            => 'Beschreibung',
            'related-product-title'  => 'Ähnliche Produkte',
            'review'                 => 'Bewertungen',
            'tax-inclusive'          => 'Inklusive aller Steuern',
            'up-sell-title'          => 'Wir haben auch andere Produkte, die Ihnen gefallen könnten!',
        ],

        'type' => [
            'abstract' => [
                'offers' => 'Kaufen Sie :qty für :price je Stück und sparen Sie :discount',
            ],
        ],

        'booking' => [
            'closed' => 'Geschlossen',

            'cart'             => [
                'booking-from' => 'Buchung von',
                'booking-till' => 'Buchung bis',
                'daily'        => 'Tagesbasis',
                'event-from'   => 'Veranstaltung von',
                'event-ticket' => 'Veranstaltungsticket',
                'event-till'   => 'Veranstaltung bis',
                'hourly'       => 'Stundenbasis',

                'integrity'    => [
                    'event'                  => [
                        'expired' => 'Diese Veranstaltung ist abgelaufen.',
                    ],

                    'missing_options'        => 'Optionen fehlen für dieses Produkt.',
                    'inventory_warning'      => 'Die angeforderte Menge ist nicht verfügbar, bitte versuchen Sie es später erneut.',
                    'select_hourly_duration' => 'Wählen Sie eine Slot-Dauer von einer Stunde.',
                ],

                'rent-from'    => 'Mieten von',
                'rent-till'    => 'Mieten bis',
                'rent-type'    => 'Miettyp',
                'renting_type' => 'Miettyp',
                'special-note' => 'Sonderwünsche/Notizen',
            ],

            'per-ticket-price' => ':price pro Ticket',
        ],
    ],

    'categories' => [
        'filters' => [
            'clear-all' => 'Alles löschen',
            'filter'    => 'Filter',
            'filters'   => 'Filter:',

            'search' => [
                'load-more'            => 'Mehr laden',
                'loading'              => 'Lädt...',
                'no-options-available' => 'Keine Optionen verfügbar.',
                'results-info'         => 'Zeige :currentCount von :totalCount Optionen',
                'title'                => 'Suche',
            ],

            'sort'      => 'Sortieren',
        ],

        'toolbar' => [
            'grid' => 'شبکه',
            'list' => 'لیست',
            'show' => 'نمایش',
        ],

        'view' => [
            'empty'     => 'Keine Produkte in dieser Kategorie verfügbar',
            'load-more' => 'Mehr laden',
        ],
    ],

    'search' => [
        'title'   => 'Dies sind die Ergebnisse für : :query',
        'suggest' => 'Stattdessen suchen nach',
        'results' => 'Suchergebnisse',

        'images' => [
            'index' => [
                'only-images-allowed'  => 'Nur Bilder (.jpeg, .jpg, .png, ..) sind erlaubt.',
                'search'               => 'Suche',
                'size-limit-error'     => 'Größenbeschränkungsfehler',
                'something-went-wrong' => 'Etwas ist schiefgelaufen, bitte versuchen Sie es später erneut.',
            ],

            'results' => [
                'analyzed-keywords' => 'Analysierte Schlüsselwörter:',
            ],
        ],
    ],

    'compare' => [
        'already-added'      => 'Artikel ist bereits zur Vergleichsliste hinzugefügt',
        'delete-all'         => 'Alle löschen',
        'empty-text'         => 'Sie haben keine Artikel in Ihrer Vergleichsliste',
        'item-add-success'   => 'Artikel erfolgreich zur Vergleichsliste hinzugefügt',
        'product-compare'    => 'Produktvergleich',
        'remove-all-success' => 'Alle Artikel erfolgreich entfernt.',
        'remove-error'       => 'Etwas ist schiefgelaufen. Bitte versuchen Sie es später erneut.',
        'remove-success'     => 'Artikel erfolgreich entfernt.',
        'title'              => 'Produktvergleich',
    ],

    'checkout' => [
        'success' => [
            'info'          => 'Wir werden Ihnen Ihre Bestelldetails und Tracking-Informationen per E-Mail senden',
            'order-id-info' => 'Ihre Bestellnummer lautet #:order_id',
            'thanks'        => 'Vielen Dank für Ihre Bestellung!',
            'title'         => 'Bestellung erfolgreich platziert',
        ],

        'cart' => [
            'continue-to-checkout'      => 'Weiter zur Kasse',
            'illegal'                   => 'Die Menge darf nicht weniger als eins sein.',
            'inactive-add'              => 'Inaktive Artikel können nicht zum Warenkorb hinzugefügt werden.',
            'inactive'                  => 'Der Artikel wurde deaktiviert und wurde daher aus dem Warenkorb entfernt.',
            'inventory-warning'         => 'Die angeforderte Menge ist nicht verfügbar, bitte versuchen Sie es später erneut.',
            'item-add-to-cart'          => 'Artikel erfolgreich hinzugefügt',
            'minimum-order-message'     => 'Mindestbestellmenge beträgt',
            'missing-fields'            => 'Einige erforderliche Felder fehlen für dieses Produkt.',
            'missing-options'           => 'Optionen fehlen für dieses Produkt.',
            'paypal-payment-cancelled'  => 'Die Paypal-Zahlung wurde abgebrochen.',
            'qty-missing'               => 'Mindestens ein Produkt sollte eine Menge von mehr als 1 haben.',
            'return-to-shop'            => 'Zurück zum Shop',
            'rule-applied'              => 'Warenkorbregel angewendet',
            'select-hourly-duration'    => 'Wählen Sie eine Stundendauer von einer Stunde aus.',
            'success-remove'            => 'Artikel wurde erfolgreich aus dem Warenkorb entfernt.',
            'suspended-account-message' => 'Ihr Konto wurde gesperrt.',

            'index' => [
                'bagisto'                  => 'Bagisto',
                'cart'                     => 'Warenkorb',
                'continue-shopping'        => 'Einkauf fortsetzen',
                'empty-product'            => 'Sie haben kein Produkt in Ihrem Warenkorb.',
                'excl-tax'                 => 'Exkl. Steuern:',
                'home'                     => 'Startseite',
                'items-selected'           => ':count Artikel ausgewählt',
                'move-to-wishlist'         => 'In die Wunschliste verschieben',
                'move-to-wishlist-success' => 'Ausgewählte Artikel wurden erfolgreich in die Wunschliste verschoben.',
                'price'                    => 'Preis',
                'product-name'             => 'Produktname',
                'quantity'                 => 'Menge',
                'quantity-update'          => 'Menge erfolgreich aktualisiert',
                'remove'                   => 'Entfernen',
                'remove-selected-success'  => 'Ausgewählte Artikel wurden erfolgreich aus dem Warenkorb entfernt.',
                'see-details'              => 'Details anzeigen',
                'select-all'               => 'Alles auswählen',
                'select-cart-item'         => 'Warenkorbartikel auswählen',
                'tax'                      => 'Steuer',
                'total'                    => 'Gesamt',
                'update-cart'              => 'Warenkorb aktualisieren',
                'view-cart'                => 'Warenkorb anzeigen',

                'cross-sell' => [
                    'title' => 'Mehr Auswahlmöglichkeiten',
                ],
            ],

            'mini-cart' => [
                'continue-to-checkout' => 'Weiter zur Kasse',
                'empty-cart'           => 'Ihr Warenkorb ist leer',
                'excl-tax'             => 'Exkl. Steuern:',
                'offer-on-orders'      => 'Erhalten Sie bis zu 30% Rabatt auf Ihre 1. Bestellung',
                'remove'               => 'Entfernen',
                'see-details'          => 'Details anzeigen',
                'shopping-cart'        => 'Warenkorb',
                'subtotal'             => 'Zwischensumme',
                'view-cart'            => 'Warenkorb anzeigen',
            ],

            'summary' => [
                'cart-summary'              => 'Warenkorb-Zusammenfassung',
                'delivery-charges'          => 'Liefergebühren',
                'delivery-charges-excl-tax' => 'Liefergebühren (exkl. Steuern)',
                'delivery-charges-incl-tax' => 'Liefergebühren (inkl. Steuern)',
                'discount-amount'           => 'Rabattbetrag',
                'grand-total'               => 'Gesamtsumme',
                'place-order'               => 'Bestellung aufgeben',
                'proceed-to-checkout'       => 'Zur Kasse gehen',
                'sub-total'                 => 'Zwischensumme',
                'sub-total-excl-tax'        => 'Zwischensumme (exkl. Steuern)',
                'sub-total-incl-tax'        => 'Zwischensumme (inkl. Steuern)',
                'tax'                       => 'Steuern',

                'estimate-shipping' => [
                    'country'        => 'Land',
                    'info'           => 'Geben Sie Ihr Ziel ein, um eine Schätzung für Versand und Steuer zu erhalten.',
                    'postcode'       => 'PLZ/Postleitzahl',
                    'select-country' => 'Land auswählen',
                    'select-state'   => 'Bundesland auswählen',
                    'state'          => 'Bundesland',
                    'title'          => 'Versand und Steuer schätzen',
                ],
            ],
        ],

        'onepage' => [
            'address' => [
                'add-new'                => 'Neue Adresse hinzufügen',
                'add-new-address'        => 'Neue Adresse hinzufügen',
                'back'                   => 'Zurück',
                'billing-address'        => 'Rechnungsadresse',
                'check-billing-address'  => 'Rechnungsadresse fehlt.',
                'check-shipping-address' => 'Versandadresse fehlt.',
                'city'                   => 'Stadt',
                'company-name'           => 'Firmenname',
                'confirm'                => 'Bestätigen',
                'country'                => 'Land',
                'email'                  => 'E-Mail',
                'first-name'             => 'Vorname',
                'last-name'              => 'Nachname',
                'postcode'               => 'PLZ/Postleitzahl',
                'proceed'                => 'Fortfahren',
                'same-as-billing'        => 'Gleiche Adresse für den Versand verwenden?',
                'save'                   => 'Speichern',
                'save-address'           => 'In Adressbuch speichern',
                'select-country'         => 'Land auswählen',
                'select-state'           => 'Bundesland auswählen',
                'shipping-address'       => 'Versandadresse',
                'state'                  => 'Bundesland',
                'street-address'         => 'Straßenadresse',
                'telephone'              => 'Telefon',
                'title'                  => 'Adresse',
                'vat-id'                 => 'USt-IdNr.',
            ],

            'index' => [
                'checkout' => 'Zur Kasse',
                'home'     => 'Startseite',
            ],

            'payment' => [
                'payment-method' => 'Zahlungsmethode',
            ],

            'shipping' => [
                'shipping-method' => 'Versandart',
            ],

            'summary' => [
                'cart-summary'              => 'Warenkorb-Zusammenfassung',
                'delivery-charges'          => 'Liefergebühren',
                'delivery-charges-excl-tax' => 'Liefergebühren (exkl. Steuern)',
                'delivery-charges-incl-tax' => 'Liefergebühren (inkl. Steuern)',
                'discount-amount'           => 'Rabattbetrag',
                'excl-tax'                  => 'Exkl. Steuern:',
                'grand-total'               => 'Gesamtsumme',
                'place-order'               => 'Bestellung aufgeben',
                'price_&_qty'               => ':price × :qty',
                'processing'                => 'Verarbeitung',
                'sub-total'                 => 'Zwischensumme',
                'sub-total-excl-tax'        => 'Zwischensumme (exkl. Steuern)',
                'sub-total-incl-tax'        => 'Zwischensumme (inkl. Steuern)',
                'tax'                       => 'Steuern',
            ],
        ],

        'coupon' => [
            'already-applied' => 'Gutscheincode wurde bereits angewendet.',
            'applied'         => 'Gutschein angewendet',
            'apply'           => 'Gutschein anwenden',
            'apply-issue'     => 'Der Gutscheincode kann nicht angewendet werden.',
            'button-title'    => 'Anwenden',
            'code'            => 'Gutscheincode',
            'discount'        => 'Gutscheinrabatt',
            'enter-your-code' => 'Geben Sie Ihren Code ein',
            'error'           => 'Etwas ist schiefgelaufen',
            'invalid'         => 'Gutscheincode ist ungültig.',
            'remove'          => 'Gutschein entfernen',
            'subtotal'        => 'Zwischensumme',
            'success-apply'   => 'Gutscheincode erfolgreich angewendet.',
        ],

        'login' => [
            'email'    => 'E-Mail',
            'password' => 'Passwort',
            'title'    => 'Anmelden',
        ],
    ],

    'home' => [
        'contact' => [
            'about'         => 'Schreiben Sie uns eine Nachricht und wir werden uns so schnell wie möglich bei Ihnen melden',
            'desc'          => 'Was beschäftigt Sie?',
            'describe-here' => 'Hier beschreiben',
            'email'         => 'E-Mail',
            'message'       => 'Nachricht',
            'name'          => 'Name',
            'phone-number'  => 'Telefonnummer',
            'submit'        => 'Absenden',
            'title'         => 'Kontaktieren Sie uns',
        ],

        'index' => [
            'categories-carousel' => 'Kategorien-Karussell',
            'image-carousel'      => 'Bilder-Karussell',
            'offer'               => 'Erhalten Sie BIS ZU 40% RABATT auf Ihre erste Bestellung, JETZT einkaufen',
            'product-carousel'    => 'Produkt-Karussell',
            'resend-verify-email' => 'Bestätigungs-E-Mail erneut senden',
            'verify-email'        => 'Bestätigen Sie Ihr E-Mail-Konto',
        ],

        'thanks-for-contact' => 'Vielen Dank für Ihre Kontaktaufnahme. Wir werden Ihnen sehr bald antworten.',
    ],

    'partials' => [
        'pagination' => [
            'next-page'          => 'Nächste Seite',
            'pagination-showing' => 'Zeige :firstItem bis :lastItem von insgesamt :total Einträgen',
            'prev-page'          => 'Vorherige Seite',
        ],
    ],

    'errors' => [
        'go-to-home' => 'Zur Startseite gehen',

        '404' => [
            'description' => 'Hoppla! Die Seite, die Sie suchen, ist im Urlaub. Es scheint, dass wir nicht finden konnten, wonach Sie gesucht haben.',
            'title'       => '404 Seite nicht gefunden',
        ],

        '401' => [
            'description' => 'Hoppla! Es sieht so aus, als hätten Sie keine Berechtigung, auf diese Seite zuzugreifen. Es scheint, dass Ihnen die erforderlichen Zugangsdaten fehlen.',
            'title'       => '401 Nicht autorisiert',
        ],

        '403' => [
            'description' => 'Hoppla! Diese Seite ist tabu. Es sieht so aus, als hätten Sie nicht die erforderlichen Berechtigungen, um diesen Inhalt anzuzeigen.',
            'title'       => '403 Verboten',
        ],

        '500' => [
            'description' => 'Hoppla! Etwas ist schiefgelaufen. Es scheint, dass wir Probleme haben, die Seite, nach der Sie suchen, zu laden.',
            'title'       => '500 Interner Serverfehler',
        ],

        '503' => [
            'description' => 'Hoppla! Es sieht so aus, als wären wir vorübergehend wegen Wartungsarbeiten nicht erreichbar. Bitte kommen Sie später wieder vorbei.',
            'title'       => '503 Dienst nicht verfügbar',
        ],
    ],

    'layouts' => [
        'address'               => 'Adresse',
        'downloadable-products' => 'Downloadbare Produkte',
        'gdpr-request'          => 'GDPR-Anfragen',
        'my-account'            => 'Mein Konto',
        'orders'                => 'Bestellungen',
        'profile'               => 'Profil',
        'reviews'               => 'Bewertungen',
        'wishlist'              => 'Wunschliste',
    ],

    'subscription' => [
        'already'             => 'Sie sind bereits für unseren Newsletter angemeldet.',
        'subscribe-success'   => 'Sie haben sich erfolgreich für unseren Newsletter angemeldet.',
        'unsubscribe-success' => 'Sie haben sich erfolgreich von unserem Newsletter abgemeldet.',
    ],

    'emails' => [
        'dear'   => 'Sehr geehrte/r :customer_name',
        'thanks' => 'Wenn Sie Hilfe benötigen, kontaktieren Sie uns bitte unter <a href=":link" style=":style">:email</a>.<br/>Vielen Dank!',

        'customers' => [
            'registration' => [
                'credentials-description' => 'Ihr Konto wurde erstellt. Ihre Kontodetails finden Sie unten:',
                'description'             => 'Ihr Konto wurde erfolgreich erstellt und Sie können sich jetzt mit Ihren E-Mail-Adresse und Passwort anmelden. Nach der Anmeldung haben Sie Zugriff auf weitere Dienste wie das Überprüfen vergangener Bestellungen, Wunschlisten und das Bearbeiten Ihrer Kontoinformationen.',
                'greeting'                => 'Willkommen und vielen Dank für Ihre Registrierung bei uns!',
                'password'                => 'Passwort',
                'sign-in'                 => 'Anmelden',
                'subject'                 => 'Neue Kundenregistrierung',
                'username-email'          => 'Benutzername/E-Mail',
            ],

            'forgot-password' => [
                'description'    => 'Sie erhalten diese E-Mail, weil wir eine Anfrage zum Zurücksetzen des Passworts für Ihr Konto erhalten haben.',
                'greeting'       => 'Passwort vergessen!',
                'reset-password' => 'Passwort zurücksetzen',
                'subject'        => 'E-Mail zum Zurücksetzen des Passworts',
            ],

            'update-password' => [
                'description' => 'Sie erhalten diese E-Mail, weil Sie Ihr Passwort aktualisiert haben.',
                'greeting'    => 'Passwort aktualisiert!',
                'subject'     => 'Passwort aktualisiert',
            ],

            'verification' => [
                'description'  => 'Bitte klicken Sie auf die Schaltfläche unten, um Ihre E-Mail-Adresse zu bestätigen.',
                'greeting'     => 'Willkommen!',
                'subject'      => 'E-Mail zur Kontobestätigung',
                'verify-email' => 'E-Mail-Adresse bestätigen',
            ],

            'commented' => [
                'description' => 'Notiz lautet - :note',
                'subject'     => 'Neuer Kommentar hinzugefügt',
            ],

            'subscribed' => [
                'description' => 'Herzlichen Glückwunsch und willkommen in unserer Newsletter-Community! Wir freuen uns, Sie an Bord zu haben und Sie über die neuesten Nachrichten, Trends und exklusive Angebote auf dem Laufenden zu halten.',
                'greeting'    => 'Willkommen in unserem Newsletter!',
                'subject'     => 'Sie! Abonnement unseres Newsletters',
                'unsubscribe' => 'Abmelden',
            ],

            'gdpr' => [
                'new-delete-request' => 'Neue Anfrage zum Löschen von Daten',
                'new-update-request' => 'Neue Anfrage zur Aktualisierung von Daten',

                'new-request' => [
                    'delete-summary' => 'Resumen de la solicitud de eliminación',
                    'message'        => 'Nachricht : ',
                    'request-status' => 'Anfragestatus : ',
                    'request-type'   => 'Anfragetyp : ',
                    'update-summary' => 'Resumen de la solicitud de actualización',
                ],

                'status-update' => [
                    'subject'        => 'Ihre GDPR-Anfrage wurde aktualisiert',
                    'summary'        => 'Der Status Ihrer GDPR-Anfrage wurde aktualisiert',
                    'request-status' => 'Anfragestatus:',
                    'request-type'   => 'Anfragetyp:',
                    'message'        => 'Nachricht:',
                ],
            ],

            'reminder' => [
                'already-paid'    => 'Falls Sie die Zahlung bereits vorgenommen haben, ignorieren Sie bitte diese Nachricht.',
                'invoice-overdue' => 'Dies ist eine freundliche Erinnerung daran, dass Ihre Rechnung überfällig ist. Bitte nehmen Sie die Zahlung so bald wie möglich vor.',
                'subject'         => 'Rechnungserinnerung',
            ],
        ],

        'contact-us' => [
            'contact-from'    => 'über das Kontaktformular der Website',
            'reply-to-mail'   => 'bitte antworten Sie auf diese E-Mail.',
            'reach-via-phone' => 'Alternativ können Sie uns telefonisch erreichen unter',
            'inquiry-from'    => 'Anfrage von',
            'to'              => 'Um Kontakt aufzunehmen mit',
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Vielen Dank für Ihre Bestellung :order_id, aufgegeben am :created_at',
                'subject'  => 'Neue Bestellbestätigung',
                'summary'  => 'Zusammenfassung der Bestellung',
                'title'    => 'Bestellbestätigung!',
            ],

            'invoiced' => [
                'greeting' => 'Ihre Rechnung #:invoice_id für die Bestellung :order_id, erstellt am :created_at',
                'subject'  => 'Neue Rechnungsbestätigung',
                'summary'  => 'Zusammenfassung der Rechnung',
                'title'    => 'Rechnungsbestätigung!',
            ],

            'shipped' => [
                'greeting' => 'Ihre Bestellung :order_id, aufgegeben am :created_at, wurde versendet',
                'subject'  => 'Neue Versandbestätigung',
                'summary'  => 'Zusammenfassung des Versands',
                'title'    => 'Bestellung versendet!',
            ],

            'refunded' => [
                'greeting' => 'Die Rückerstattung wurde für die Bestellung :order_id, aufgegeben am :created_at, initiiert',
                'subject'  => 'Neue Rückerstattungsbestätigung',
                'summary'  => 'Zusammenfassung der Rückerstattung',
                'title'    => 'Bestellung zurückerstattet!',
            ],

            'canceled' => [
                'greeting' => 'Ihre Bestellung :order_id, aufgegeben am :created_at, wurde storniert',
                'subject'  => 'Neue Bestellstornierungsbestätigung',
                'summary'  => 'Zusammenfassung der Bestellung',
                'title'    => 'Bestellung storniert!',
            ],

            'commented' => [
                'subject' => 'Neuer Kommentar hinzugefügt',
                'title'   => 'Neuer Kommentar zu Ihrer Bestellung :order_id, aufgegeben am :created_at, hinzugefügt',
            ],

            'billing-address'            => 'Rechnungsadresse',
            'carrier'                    => 'Versanddienst',
            'contact'                    => 'Kontakt',
            'discount'                   => 'Rabatt',
            'excl-tax'                   => 'Ohne Steuern: ',
            'grand-total'                => 'Gesamtsumme',
            'name'                       => 'Name',
            'payment'                    => 'Zahlung',
            'price'                      => 'Preis',
            'qty'                        => 'Menge',
            'shipping'                   => 'Versand',
            'shipping-address'           => 'Lieferadresse',
            'shipping-handling'          => 'Versand und Bearbeitung',
            'shipping-handling-excl-tax' => 'Versand und Bearbeitung (ohne Steuern)',
            'shipping-handling-incl-tax' => 'Versand und Bearbeitung (inkl. Steuern)',
            'sku'                        => 'Artikelnummer',
            'subtotal'                   => 'Zwischensumme',
            'subtotal-excl-tax'          => 'Zwischensumme (ohne Steuern)',
            'subtotal-incl-tax'          => 'Zwischensumme (inkl. Steuern)',
            'tax'                        => 'Steuern',
            'tracking-number'            => 'Sendungsnummer: :tracking_number',
        ],
    ],
];
